<?php
/**
 * Recent post widget
 * @package automatic
 */

class WP_Automatic_Widget_Contact extends WP_Widget {

    public function __construct() {
        $widget_ops = array( 'classname' => 'automatic_widget_contact', 'description' => esc_html__( "Display a contact", "automatic") );
        parent::__construct( 'automatic-contact', esc_html__( '[Automatic] Contact', 'automatic' ), $widget_ops );
        $this->alt_option_name = 'automatic_widget_contact';
    }

    public function widget( $args, $instance ) {
		$automatic_config = automatic_settings();
        echo $args['before_widget'];
			if($instance['show_logo'] !=''){echo '<div class="footer-logo"><a href="'. esc_url( home_url( '/' ) ) .'">'; automatic_logo(); echo '</a></div>';}
		?>
			<div class="info-box f-contact-info">
			    <?php

                if($instance['show_phone'] !=''){
                    echo '<div class="tel-holder"><span class="tel-box"><i class="fa fa-phone"></i>'. wp_kses_post($automatic_config['automatic_phone']) .'</span></div>';
                }
				if($instance['show_mail'] !=''){
					echo '<div class="mail-box2 tel-holder"><span class="mail-box"><i class="fa fa-envelope-o"></i>'. wp_kses_post($automatic_config['automatic_mail']) .'</span></div>';
				}
                if($instance['show_address'] !=''){
                    echo '<div class="tel-holder"><address><i class="fa fa-map-marker"></i>'. wp_kses_post($automatic_config['automatic_address']).'</address></div>';
                }
                ?>
                <ul class="contact-social">
                    <?php
						global $automatic_social_array;
						$automatic_socials = $automatic_social_array;
						if (count($automatic_social_array)>0) :
							foreach( $automatic_socials as $key => $value):
								if($instance['show_'.$key] == 'show'){
									echo '<li class="social"> <a href="'.esc_url($automatic_config['social_'.$key.'_link']).'" target="_blank"><i class="fa fa-'.$key.'"></i></a></li>';
								}
							endforeach;
						endif; // End automatic_social_array
					?>
                </ul>
			</div>
        <?php echo $args['after_widget']; ?>
<?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $automatic_contact_args= array('logo','phone','mail','address');
		foreach( $automatic_contact_args as $automatic_contact_arg){
			$instance['show_'.$automatic_contact_arg] = $new_instance['show_'.$automatic_contact_arg];
		}
		global $automatic_social_array;
		$automatic_socials = $automatic_social_array;
		if (count($automatic_social_array)>0) :
			foreach( $automatic_socials as $key => $value):
				$instance['show_'.$key] = $new_instance['show_'.$key];
			endforeach;
		endif; // End automatic_social_array
        return $instance;
    }

    public function form( $instance ) {
		global $automatic_social_array;
		$automatic_socials = $automatic_social_array;
		$automatic_contact_args= array('logo','phone','mail','address');
		foreach( $automatic_contact_args as $automatic_contact_arg){
			$show_contact  = isset( $instance['show_'.$automatic_contact_arg] ) ? esc_attr( $instance['show_'.$automatic_contact_arg] ) : '';
?>
		<p>
			<input type="checkbox" class="widefat" id="<?php echo ($this->get_field_id( 'show_'.$automatic_contact_arg)); ?>" name="<?php echo ($this->get_field_name( 'show_'.$automatic_contact_arg)); ?>" value="show" <?php checked( $show_contact, 'show' ); ?>/>
			<label for="<?php echo ($this->get_field_id( 'show_'.$automatic_contact_arg)); ?>"><?php  echo esc_html__( 'Show','automatic' ).' '. $automatic_contact_arg; ?></label>
		</p>
        <?php
		}
		if (count($automatic_social_array)>0) :
			foreach( $automatic_socials as $key => $value):
				$show_social  = isset( $instance['show_'.$key] ) ? esc_attr( $instance['show_'.$key] ) : '';
        ?>
				<p>
					<input type="checkbox" class="widefat" id="<?php echo ($this->get_field_id( 'show_'.$key)); ?>" name="<?php echo ($this->get_field_name( 'show_'.$key)); ?>" value="show" <?php checked( $show_social, 'show' ); ?>/>
					<label for="<?php echo ($this->get_field_id( 'show_'.$key)); ?>"><?php  echo esc_html__( 'Show','automatic' ).' '. $value; ?></label>
				</p>
        <?php
			endforeach;
		endif; // End automatic_social_array
    }
}